/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LOTRTeleporterElvenPortal
extends Teleporter {
    private final WorldServer theWorld;
    private final LongHashMap portalPositions = new LongHashMap();
    private final List portalTimes = new ArrayList();
    private Random rand = new Random();

    public LOTRTeleporterElvenPortal(WorldServer world) {
        super(world);
        this.theWorld = world;
    }

    public void func_77185_a(Entity entity, double d, double d1, double d2, float f) {
        if (!this.func_77184_b(entity, d, d1, d2, f)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, d, d1, d2, f);
        }
    }

    public boolean func_77184_b(Entity entity, double d, double d1, double d2, float f) {
        int range = 128;
        double distanceToPortal = -1.0;
        int i = 0;
        int j = 0;
        int k = 0;
        int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int posZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        long chunkLocation = ChunkCoordIntPair.func_77272_a((int)posX, (int)posZ);
        boolean isChunkLocationInPortalPositions = true;
        if (this.portalPositions.func_76161_b(chunkLocation)) {
            Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.portalPositions.func_76164_a(chunkLocation);
            distanceToPortal = 0.0;
            i = portalposition.field_71574_a;
            j = portalposition.field_71572_b;
            k = portalposition.field_71573_c;
            portalposition.field_85087_d = this.theWorld.func_82737_E();
            isChunkLocationInPortalPositions = false;
        } else {
            for (int i1 = posX - range; i1 <= posX + range; ++i1) {
                double xDistance = (double)i1 + 0.5 - entity.field_70165_t;
                for (int k1 = posZ - range; k1 <= posZ + range; ++k1) {
                    double zDistance = (double)k1 + 0.5 - entity.field_70161_v;
                    for (int j1 = this.theWorld.func_72940_L() - 1; j1 >= 0; --j1) {
                        boolean portalHere = true;
                        for (int i2 = i1 - 1; i2 <= i1 + 1; ++i2) {
                            for (int k2 = k1 - 1; k2 <= k1 + 1; ++k2) {
                                if (this.theWorld.func_147439_a(i2, j1, k2) == LOTRMod.elvenPortal) continue;
                                portalHere = false;
                            }
                        }
                        if (!portalHere) continue;
                        double yDistance = (double)j1 + 0.5 - entity.field_70163_u;
                        double distanceSq = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
                        if (distanceToPortal >= 0.0 && distanceSq >= distanceToPortal) continue;
                        distanceToPortal = distanceSq;
                        i = i1;
                        j = j1;
                        k = k1;
                    }
                }
            }
        }
        if (distanceToPortal >= 0.0) {
            if (isChunkLocationInPortalPositions) {
                this.portalPositions.func_76163_a(chunkLocation, (Object)new Teleporter.PortalPosition((Teleporter)this, i, j, k, this.theWorld.func_82737_E()));
                this.portalTimes.add(chunkLocation);
            }
            int side = this.rand.nextInt(4);
            switch (side) {
                case 0: {
                    entity.func_70012_b((double)(i - 2) + 0.5, (double)(j + 1), (double)(k - 1) + 0.25 + (double)(this.rand.nextFloat() * 2.0f), entity.field_70177_z, entity.field_70125_A);
                    break;
                }
                case 1: {
                    entity.func_70012_b((double)(i + 2) + 0.5, (double)(j + 1), (double)(k - 1) + 0.25 + (double)(this.rand.nextFloat() * 2.0f), entity.field_70177_z, entity.field_70125_A);
                    break;
                }
                case 2: {
                    entity.func_70012_b((double)(i - 1) + 0.25 + (double)(this.rand.nextFloat() * 2.0f), (double)(j + 1), (double)(k - 2) + 0.25, entity.field_70177_z, entity.field_70125_A);
                    break;
                }
                case 3: {
                    entity.func_70012_b((double)(i - 1) + 0.25 + (double)(this.rand.nextFloat() * 2.0f), (double)(j + 1), (double)(k + 2) + 0.25, entity.field_70177_z, entity.field_70125_A);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int k2;
        int j2;
        int k1;
        int i1;
        int i2;
        int j1;
        int range = 16;
        double distanceToPortal = -1.0;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        int posX = i;
        int posY = j;
        int posZ = k;
        for (int i12 = i - range; i12 <= i + range; ++i12) {
            double xDistance = (double)i12 + 0.5 - entity.field_70165_t;
            for (int k12 = k - range; k12 <= k + range; ++k12) {
                double zDistance = (double)k12 + 0.5 - entity.field_70161_v;
                block2: for (j1 = this.theWorld.func_72940_L() - 1; j1 >= 0; --j1) {
                    if (!this.theWorld.func_147437_c(i12, j1, k12)) continue;
                    while (j1 > 0 && this.theWorld.func_147437_c(i12, j1 - 1, k12)) {
                        --j1;
                    }
                    for (i2 = i12 - 2; i2 <= i12 + 2; ++i2) {
                        for (int k22 = k12 - 2; k22 <= k12 + 2; ++k22) {
                            for (int j22 = -1; j22 <= 2; ++j22) {
                                int j3 = j1 + j22;
                                if (j22 < 0 && !LOTRMod.isOpaque((World)this.theWorld, i2, j3, k22) || j22 >= 0 && !this.theWorld.func_147437_c(i2, j3, k22)) continue block2;
                            }
                        }
                    }
                    double yDistance = (double)j1 + 0.5 - entity.field_70163_u;
                    double distanceSq = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
                    if (distanceToPortal >= 0.0 && distanceSq >= distanceToPortal) continue;
                    distanceToPortal = distanceSq;
                    posX = i12;
                    posY = j1;
                    posZ = k12;
                }
            }
        }
        int actualPosX = posX;
        int actualPosY = posY;
        int actualPosZ = posZ;
        boolean generateDirtBelow = false;
        if (distanceToPortal < 0.0) {
            if (posY < 70) {
                posY = 70;
            }
            if (posY > this.theWorld.func_72940_L() - 10) {
                posY = this.theWorld.func_72940_L() - 10;
            }
            actualPosY = posY;
            generateDirtBelow = true;
        }
        for (i1 = -2; i1 <= 2; ++i1) {
            for (k1 = -2; k1 <= 2; ++k1) {
                int n = j1 = generateDirtBelow ? -1 : 0;
                while (j1 <= 2) {
                    i2 = actualPosX + i1;
                    j2 = actualPosY + j1;
                    k2 = actualPosZ + k1;
                    if (j1 > 0) {
                        this.theWorld.func_147465_d(i2, j2, k2, Blocks.field_150350_a, 0, 2);
                    } else if (j1 < 0 && generateDirtBelow) {
                        this.theWorld.func_147465_d(i2, j2, k2, Blocks.field_150346_d, 0, 2);
                    } else {
                        boolean isFrame = i1 == -2 || i1 == 2 || k1 == -2 || k1 == 2;
                        this.theWorld.func_147465_d(i2, j2, k2, isFrame ? LOTRMod.quenditeGrass : LOTRMod.elvenPortal, 0, 2);
                    }
                    ++j1;
                }
            }
        }
        for (i1 = -3; i1 <= 3; ++i1) {
            for (k1 = -3; k1 <= 3; ++k1) {
                int n = j1 = generateDirtBelow ? -2 : -1;
                while (j1 <= 3) {
                    i2 = actualPosX + i1;
                    j2 = actualPosY + j1;
                    k2 = actualPosZ + k1;
                    this.theWorld.func_147459_d(i2, j2, k2, this.theWorld.func_147439_a(i2, j2, k2));
                    ++j1;
                }
            }
        }
        return true;
    }

    public void func_85189_a(long time) {
        if (time % 100L == 0L) {
            Iterator iterator = this.portalTimes.iterator();
            long j = time - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.portalPositions.func_76164_a(olong.longValue());
                if (portalposition != null && portalposition.field_85087_d >= j) continue;
                iterator.remove();
                this.portalPositions.func_76159_d(olong.longValue());
            }
        }
    }
}

